<?php
// public_html/api/topup/resolve_uid.php
require_once __DIR__.'/../../config/db.php';
header('Content-Type: application/json; charset=utf-8');
$uid = strtoupper(trim($_GET['uid'] ?? ''));
if($uid==='' || !preg_match('/^[0-9A-F]+$/',$uid)){
  echo json_encode(['ok'=>false,'err'=>'bad_uid']); exit;
}
$st = $pdo->prepare("SELECT a.id, a.name, a.status FROM cards c JOIN accounts a ON a.id=c.account_id WHERE c.uid_hex=? LIMIT 1");
$st->execute([$uid]); $acc = $st->fetch();
if(!$acc){ echo json_encode(['ok'=>true,'account'=>null]); exit; }
echo json_encode(['ok'=>true,'account'=>$acc], JSON_UNESCAPED_UNICODE);
