
SET NAMES utf8mb4;
CREATE TABLE IF NOT EXISTS users (
  id BIGINT UNSIGNED PRIMARY KEY AUTO_INCREMENT,
  username VARCHAR(64) NOT NULL UNIQUE,
  pass_hash VARCHAR(255) NOT NULL,
  created_at TIMESTAMP NULL DEFAULT CURRENT_TIMESTAMP
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;
CREATE TABLE IF NOT EXISTS accounts (
  id BIGINT UNSIGNED PRIMARY KEY AUTO_INCREMENT,
  user_id BIGINT UNSIGNED NOT NULL,
  name VARCHAR(120),
  balance DECIMAL(18,2) NOT NULL DEFAULT 0.00,
  status VARCHAR(16) NOT NULL DEFAULT 'active',
  created_at TIMESTAMP NULL DEFAULT CURRENT_TIMESTAMP,
  KEY (user_id),
  CONSTRAINT FK_accounts_user FOREIGN KEY (user_id) REFERENCES users(id) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;
CREATE TABLE IF NOT EXISTS cards (
  id BIGINT UNSIGNED PRIMARY KEY AUTO_INCREMENT,
  account_id BIGINT UNSIGNED NOT NULL,
  uid_hex VARCHAR(32) NOT NULL UNIQUE,
  status VARCHAR(16) NOT NULL DEFAULT 'active',
  created_at TIMESTAMP NULL DEFAULT CURRENT_TIMESTAMP,
  KEY (account_id),
  CONSTRAINT FK_cards_account FOREIGN KEY (account_id) REFERENCES accounts(id) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;
CREATE TABLE IF NOT EXISTS transactions (
  id BIGINT UNSIGNED PRIMARY KEY AUTO_INCREMENT,
  account_id BIGINT UNSIGNED NOT NULL,
  type VARCHAR(16) NOT NULL,
  amount DECIMAL(18,2) NOT NULL,
  ref_code VARCHAR(64) DEFAULT NULL,
  created_at TIMESTAMP NULL DEFAULT CURRENT_TIMESTAMP,
  KEY (account_id, created_at),
  CONSTRAINT FK_tx_acc FOREIGN KEY (account_id) REFERENCES accounts(id) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;
CREATE TABLE IF NOT EXISTS pending_topups (
  id BIGINT UNSIGNED PRIMARY KEY AUTO_INCREMENT,
  uid_hex VARCHAR(32) NOT NULL,
  amount DECIMAL(18,2) NOT NULL,
  status ENUM('pending','processing','done','failed') NOT NULL DEFAULT 'pending',
  result_msg VARCHAR(255) DEFAULT NULL,
  created_at TIMESTAMP NULL DEFAULT CURRENT_TIMESTAMP,
  updated_at TIMESTAMP NULL DEFAULT NULL,
  KEY (uid_hex),
  KEY (status, created_at)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;
-- demo user: 123456
INSERT IGNORE INTO users(username, pass_hash) VALUES ('demo', '$2y$10$8C4m6Jp8QGkN3y2gAq3W6e1IuD3mI0bHqC8b4mvI..lq0b2H3b0lS');
INSERT IGNORE INTO accounts(user_id, name, balance) SELECT id, 'Demo Hesap', 0.00 FROM users WHERE username='demo' LIMIT 1;
